require( "scripts/style.lua" );

kButtonSpacingY = 50;		-- Put our buttons N pixels apart
kButtonY = 20;				-- 

MakeDialog
{
	-- Name the modal dialog
	name = "popupmenu",
	
	tTransitionWindow
	{
		x = 0, y = 0, w = kMax, h = kMax, 
		speed_in = slide_speed_in, speed_out = slide_speed_out, accel_in = slice_accel_in, accel_out = slide_accel_out,
		
		Bitmap
		{
			image = "backgrounds/dialog",
			mask = exists("backgrounds/dialog.mask.png"),
			x = kCenter,
			y = kCenter,
			
			Bitmap
			{
				image = gDialogTable.popupgfx,
				x = 10, -- kCenter,
				y = 10, -- kCenter,
			},
			
			SetStyle(DialogTitleText),
			Text
			{
				label = gDialogTable.title,
				x = kCenter,
				y = 0,
				w = 250,
				h = 80,	
				flags = kHAlignCenter + kVAlignCenter,
			},
			
			SetStyle(DialogBodyText),
			Text
			{
				font = {standardFont, 16, BlackColor },
				label = gDialogTable.body,	
				x = kCenter,
				y = 60,
				w = 509 - 280,
				h = 231 - 60,	
				flags = kHAlignCenter,
			},
			
			SetStyle(ThinButtonStyle),
			Button
			{
				align = kVAlignBottom, -- kHAlignRight,
				x = kCenter,
				y = kMax-30,
				label = "ok",
				command = StartClose, -- Just close this window
			},
		
		},
	},
};

MET_Count("popup");
